/*  NAME:
        SUFeral.h

    DESCRIPTION:
        Feral additions to Sparkle

    COPYRIGHT:
		Copyright © 2009, Feral Interactive, Ltd.
		<http://www.feralinteractive.com/>
 
 		If you have received this software as part of a source code distribution
		from Feral Interactive Ltd, subject to the limits of a supporting 
		contractual agreement, permission to use, copy, modify, this software 
		is hereby granted.
 
		Feral Interactive retains full ownership of this software including 
		all changes made by third parties under contract.
 
		All use of this software in products not owned or commissioned by 
		Feral Interactive requires the written permission of Feral Interactive Ltd.
 ___________________________________________________________________________
*/
#ifndef SUFERAL_HDR
#define SUFERAL_HDR
//=============================================================================
//      Include files
//-----------------------------------------------------------------------------
#include <Carbon/Carbon.h>




//=============================================================================
//      Defines
//-----------------------------------------------------------------------------
#define FERAL_SPARKLE				1
#define FERAL_ONLY(...)				__VA_ARGS__		
#define FERAL_EXCLUDE(...)			
#define	FERAL_CAST(_type_)			(_type_)
#define FERAL_EXPORT				__attribute__((visibility("default"))) 



//=============================================================================
//      Types
//-----------------------------------------------------------------------------
typedef enum
{
	kFeralDataString,
	kFeralDataUInt32,
	kFeralDataDate,
	kFeralDataDouble

} FeralDataType;

// Function pointers
typedef bool (*FeralGetPrefsValueFunc)(CFStringRef theKey, FeralDataType theFeralDataType, void *theResult);
typedef void (*FeralSetPrefsValueFunc)(CFStringRef theKey, FeralDataType theFeralDataType, void *theValue);





//=============================================================================
//      Globals
//-----------------------------------------------------------------------------
extern FeralGetPrefsValueFunc gFeralGetPrefsFunc;
extern FeralSetPrefsValueFunc gFeralSetPrefsFunc;




#endif // SUFERAL_HDR

